import Content from "./Content";
import { constructMetadata } from "@/components/utils/seo";

const seoData = {
  ar: {
    title: "الوظائف",
    description: "انضم إلى فريق عملنا وساهم في بناء مشاريع نوعية تترك أثرًا حقيقيًا. نوفر بيئة مهنية محفّزة، وفرصًا للنمو والتطوير، ووظائف متنوعة تلائم الخبرات الهندسية والإدارية والفنية."
  },
  en: {
    title: "Careers",
    description: "Join our team and contribute to building high-quality projects that leave a real impact. We provide a stimulating professional environment, opportunities for growth and development, and diverse roles suited for engineering, administrative, and technical expertise."
  }
};


type Props = {
  params: { locale: string }
}

export async function generateMetadata({ params }: Props) {
  const locale = params.locale === 'en' ? 'en' : 'ar';
  const data = seoData[locale];

  return constructMetadata({
    title: data.title,
    description: data.description,
    canonicalUrlRelative: `/${locale}/innovation`,
  });
}

export default function Page() {
  return (
    <Content />
  );
}